<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/summernote-bs4.min.js", "js/pages/add-page.js");

// Metadata informations of this page
$page_title = "Add Page";
$page_slug	= "add-page";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

if($_SESSION["RANK"] == 0) {
	header("Location: home.php?action=forbidden");
	exit;	
}

if(!isset($_GET["id"])) {
	header("Location: home.php?action=forbidden");
	exit;		
}

$page_id = intval($_GET["id"]);

// Check if user exists...
$page_sql = $dbh->prepare("	SELECT *
							FROM custom_page
							WHERE id = :page_id
							");
					
$page_sql->bindParam(':page_id', $page_id);
$page_sql->execute();
	
$page = $page_sql->fetch();

$title_page = $page["title"];
$content_page = $page["content"];

$user_id = $_SESSION["USER_ID"];
$error = "";


if($_POST) {
	
	if(TEST_MODE) {
		$error = "You can't update the page in demo mode.";
	} else {
	
		if(isset($_POST["title"]) && isset($_POST["content"])) {
			
			$title_page = $_POST["title"];
			$content_page = $_POST["content"];
			
			if(empty($title_page) || empty($content_page)) {
				
				$error = "Please fill the form.";
				
			} else {
				
				$site_config = $dbh->prepare("UPDATE custom_page SET title = :title, content = :content WHERE id = :page_id");
				$site_config->bindParam(":title", $title_page);
				$site_config->bindParam(":content", $content_page);
				$site_config->bindParam(":page_id", $page_id);
				$site_config->execute();
				
				header("Location: manage-pages.php?action=edited");
				
			}
			
		} else {
			
			$error = "Please fill the form.";
			
		}
	
	}
	
}

	
// -- Include the header template
include("templates/headers/admin_header.php")
?>

<div class="row">

	<div class="inner-container content" id="main-content">
					
		<h3>Edit Page</h3>
		
		<div class="content-inner">	
			<form method="POST" action="">
				<div class="form-group">
			    	<label class="control-label" for="inputTitle">Title</label>
					<div class="controls">
						<input type="text" id="inputTitle" placeholder="Write the title of this custom page" class="form-control" name="title" value="<?php echo $title_page; ?>">
					</div>
			    </div>
			    <div class="form-group">
			    	<label class="control-label" for="inputContent">Content</label>
					<div class="controls">
						<textarea class="form-control summernote" name="content"><?php echo $content_page; ?></textarea>
					</div>
			    </div>
			    <?php
				if($error != "") {	
				?>
				<div class="alert alert-danger alert-center">
					<?php echo $error; ?>              
			    </div>
			    <?php
				}
				?>
				<center>
					<button type="submit" class="btn btn-primary btn-edit-config">Edit Page <i class="fas fa-check"></i></button>
				</center>
			</form>
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>